// VentanaPrincipal.cpp: implementation of the VentanaPrincipal class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VentanaPrincipal.h"
#include <DWLRegion.h>
//#include <DWLSO.h>
#include <DWLArchivosWindows.h>
#include <shellapi.h>
#include <DWLDebug.h>
#include "InstaladorBubaTronikApp.h"

#define ID_BOTON_INSTALAR		2233
#define ID_BOTON_SALIR			2234
#define ID_PATHDESTINO			2235
#define ID_BARRA_PROGRESO		2236
#define ID_MARCA_MOSTRARNOTAS	2237
#define ID_MARCA_ACCESODIRECTO	2238
#define ID_MARCA_EJECUTAR		2239


#define ALTO_INSTALADOR   240
#define ANCHO_INSTALADOR  500


VentanaPrincipal::VentanaPrincipal(void) {
	ActualizacionDesdeElPlayer = false;
}

VentanaPrincipal::~VentanaPrincipal(void) {

}
/*
LRESULT CALLBACK VentanaPrincipal::GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch (uMsg) {
		ENLACE_Evento_Cerrar();
		ENLACE_Evento_Mouse_Movimiento();
		ENLACE_BotonEx_Evento_Mouse_Click();
		ENLACE_Evento_PintarHDC();
		ENLACE_Evento_BorrarFondoHDC();
		ENLACE_EdicionDesplegableEx_Evento_CambioSeleccion();
		ENLACE_MarcaEx_Evento_Mouse_Click();
	}
	return DWLVentanaEx::GestorMensajes(uMsg, wParam, lParam);
}*/

LRESULT VentanaPrincipal::Evento_MarcaEx_Mouse_Click(const UINT Boton, const int cX, const int cY, const UINT cID) {
	switch (cID) {
		case ID_MARCA_MOSTRARNOTAS	: Marca_MostrarNotas.Marcar(!Marca_MostrarNotas.Marcado());				break;
		case ID_MARCA_ACCESODIRECTO : Marca_CrearAccesoDirecto.Marcar(!Marca_CrearAccesoDirecto.Marcado()); break;
		case ID_MARCA_EJECUTAR		: Marca_EjecutarBubaTronik.Marcar(!Marca_EjecutarBubaTronik.Marcado()); break;
	}
	return 0;
}


LRESULT VentanaPrincipal::Evento_EdicionDesplegableEx_CambioSeleccion(const TCHAR *NuevoTexto, const UINT IDEdicionTexto) {
	DWL::DWLString PathFinal;
	PathFinal = NuevoTexto;
	PathFinal += TEXT("BubaTronik\\");
	Edit.Texto(PathFinal(), Edit.Icono());
	return 0;
}


void VentanaPrincipal::Crear(void) {
//	ActualizacionDesdeElPlayer = true;
	// Cierro el reproductor si esta abierto
	HWND VentanaPlayer = FindWindow(TEXT("BubaTronik"), NULL);
	if (VentanaPlayer != NULL) SendMessage(VentanaPlayer, WM_CLOSE, 0, 0);

	ColoresBoton.Borde = RGB(128,128,128);
	ColoresBarra.Borde = RGB(128,128,128);

	DWL::DWLString Titulo;
	if (ActualizacionDesdeElPlayer == false)	Titulo = TEXT("Instalacin de BubaTronik");
	else										Titulo = TEXT("Actualizando BubaTronik");

	CrearVentana(NULL, TEXT("Instalacion_BubaTronik"), WS_POPUP | WS_SYSMENU, Titulo(), 100, 100, ANCHO_INSTALADOR, ALTO_INSTALADOR, NULL);
//	Edit.Destruir();
//CrearEdicionDesplegableEx(const long Estilos, HWND hWndParent, const TCHAR *nTexto, const int cX, const int cY, const int cAncho, const int cAlto, const int nAltoLista, const int cID, const bool nTextoModificable = true, const int nIcono = 0, const Enums::DWLEdicionDesplegableEx_Tipo TipoEdicion = Enums::Tipo_ListaDesplegable);
	Edit.CrearEdicionDesplegableEx(WS_CHILD | WS_VISIBLE, _hWnd, Ex.PathDestinoDefecto(), 10 , 133, 480, 20, 300, ID_PATHDESTINO, false, 0, DWL_Enum_EdicionDesplegableEx_Tipo_BuscarDirectorio);
//	Edit.CrearEdicionTextoEx(WS_CHILD | WS_VISIBLE, _hWnd, Ex.PathDestinoDefecto(), 10, 130, 480, 20, ID_PATHDESTINO);
	Barra_Progreso.CrearBarraEx(WS_CHILD | WS_VISIBLE, _hWnd, 10, 158, 480, 8, ID_BARRA_PROGRESO);
	
	Boton_Instalar.CrearBotonEx(WS_CHILD | WS_VISIBLE, _hWnd, TEXT("Instalar"), ANCHO_INSTALADOR - 90, 185, 80, 20, ID_BOTON_INSTALAR);
	Boton_Salir.CrearBotonEx(WS_CHILD | WS_VISIBLE, _hWnd, TEXT("Salir"), ANCHO_INSTALADOR - 90, 210, 80, 20, ID_BOTON_SALIR);

	if (ActualizacionDesdeElPlayer == true) {
		Edit.Activado(FALSE);
		Boton_Instalar.Activado(FALSE);
		Boton_Salir.Activado(FALSE);
	}

	Marca_CrearAccesoDirecto.CrearMarcaEx(WS_CHILD | WS_VISIBLE, _hWnd, TEXT("Crear acceso directo en el escritorio."), 10, 170, ID_MARCA_ACCESODIRECTO, true);
	Marca_MostrarNotas.CrearMarcaEx(WS_CHILD | WS_VISIBLE, _hWnd, TEXT("Mostrar notas de la version."), 10, 190, ID_MARCA_MOSTRARNOTAS, true);
	Marca_EjecutarBubaTronik.CrearMarcaEx(WS_CHILD | WS_VISIBLE, _hWnd, TEXT("Ejecutar Bubatronik al terminar la instalacin."), 10, 210, ID_MARCA_EJECUTAR, true);

	
	Marca_CrearAccesoDirecto.MarcaEx_Estilos.Colores.TextoNormal		= DWL::SO::DWLEstilos::Colores.ControlEx_Texto_Normal;
	Marca_CrearAccesoDirecto.MarcaEx_Estilos.Colores.TextoResaltado		= DWL::SO::DWLEstilos::Colores.ControlEx_Texto_Resaltado;
	Marca_CrearAccesoDirecto.MarcaEx_Estilos.Colores.TextoPresionado	= DWL::SO::DWLEstilos::Colores.ControlEx_Texto_Presionado;

	Marca_MostrarNotas.MarcaEx_Estilos.Colores.TextoNormal				= DWL::SO::DWLEstilos::Colores.ControlEx_Texto_Normal;
	Marca_MostrarNotas.MarcaEx_Estilos.Colores.TextoResaltado			= DWL::SO::DWLEstilos::Colores.ControlEx_Texto_Resaltado;
	Marca_MostrarNotas.MarcaEx_Estilos.Colores.TextoPresionado			= DWL::SO::DWLEstilos::Colores.ControlEx_Texto_Presionado;

	Marca_EjecutarBubaTronik.MarcaEx_Estilos.Colores.TextoNormal		= DWL::SO::DWLEstilos::Colores.ControlEx_Texto_Normal;
	Marca_EjecutarBubaTronik.MarcaEx_Estilos.Colores.TextoResaltado		= DWL::SO::DWLEstilos::Colores.ControlEx_Texto_Resaltado;
	Marca_EjecutarBubaTronik.MarcaEx_Estilos.Colores.TextoPresionado	= DWL::SO::DWLEstilos::Colores.ControlEx_Texto_Presionado;

	DWL::GDI::DWLRegion Region(0, 0, ANCHO_INSTALADOR, ALTO_INSTALADOR - 2, 11, 11);
//	DWL::GDI::DWLRegion Region2(4, 4, ANCHO_INSTALADOR - 4, ANCHO_INSTALADOR - 6, 11, 11);
//	Region.CombinarRegion(&Region2, &Borde, RGN_XOR);
	Region.AsignarRegionVentana(_hWnd, FALSE);
	Minimizable(true);
	Visible(TRUE);

	if (ActualizacionDesdeElPlayer == true) {

		Marca_CrearAccesoDirecto.Activado(FALSE);
		Marca_MostrarNotas.Activado(FALSE);
		Marca_EjecutarBubaTronik.Activado(FALSE);

		int NumArgs = 0;
		LPWSTR *Args = CommandLineToArgvW(GetCommandLine(), &NumArgs);
		if (NumArgs > 1) {
			Edit.Texto(Args[1]);
		}
		LocalFree(Args);

/*		TCHAR PathApp[1024];
		DWORD Size = GetModuleFileName(NULL, PathApp, 1024);
		for (Size; Size > 0; Size --) {
			if (PathApp[Size] == TCHAR('\\')) {
				break;
			}
		}
		PathApp[Size + 1] = 0;
		Edit.Texto(PathApp);*/

		// Esperamos a que se cierre el reproductor
//		HANDLE MutexPlayer = OpenMutex(NULL, FALSE, TEXT("Mutex_BubaTronik"));
//		while (MutexPlayer != NULL) OpenMutex(NULL, FALSE, TEXT("Mutex_BubaTronik"));
		// proceso mensajes de pintado
		MSG Message;
		for (int n = 0; n != 100; n++) {
			if (PeekMessage(&Message, NULL, 0, 0, PM_REMOVE)) {		// Minetras la Ventana retorne Mensajes
				TranslateMessage(&Message);                     // Traduzco el Mensaje
				DispatchMessage(&Message);                      // Paso el Mensaje a la Ventana
			}  
		}
		// Espero 3 segundos a que terminen de descargarse las dlls del reproductor
		Sleep(3000);


		// Empezamos la actualizacion
		Instalar();
	}


	// Miramos si existe la BD en el directorio de BubaTronik, y en ese caso la movemos a AppData
	DWL::DWLString BDPATH;
	BDPATH = Edit.Texto();
	if (BDPATH[BDPATH.Tam() - 1] != TEXT('\\')) BDPATH += TEXT('\\');
	BDPATH += TEXT("BD.BTR");
	TCHAR NPATH[MAX_PATH];
	if (GetShortPathName(BDPATH(), NPATH, MAX_PATH) != 0) {
		DWL::DWLString AppData;
		Sistema.Directorio.AppData(AppData);
		AppData += TEXT("\\BubaTronik\\");
		CreateDirectory(AppData(), NULL);
		AppData += TEXT("BD.BTR");
		CopyFile(BDPATH(), AppData(), TRUE);
		DeleteFile(BDPATH());
	}

}


LRESULT VentanaPrincipal::Evento_Pintar(HDC hDC, PAINTSTRUCT &PS) {
	DWL::GDI::DWLhDC		DC(hDC, ANCHO_INSTALADOR, ALTO_INSTALADOR); // Creo DC Compatible
	DWL::GDI::DWLRegion		Region(_hWnd);
	DWL::GDI::DWLBrocha		Brocha(RGB(190,190,190));
	DWL::GDI::DWLRecta		Recta(0, 0, ANCHO_INSTALADOR, ALTO_INSTALADOR / 2);
	DWL::GDI::DWLFuente     Fuente;
	DWL::GDI::DWLFuente     Fuente2;
	DWL::DWLString TituloStr;
	DWL::DWLString TextoStr;

	Fuente.CrearFuente(TEXT("Tahoma"), 15, true, false, false, false);
	Fuente2.CrearFuente(TEXT("Tahoma"), 13, false, false, false, false);
	// Pinto el fondo
	DC.PintaGradient(RGB(200,200,200), RGB(150,150,150), &Recta, false);
	Recta.Asignar(0, ALTO_INSTALADOR / 2, ANCHO_INSTALADOR, ALTO_INSTALADOR);
	DC.PintaGradient(RGB(150,150,150), RGB(200,200,200), &Recta, false);
	// Pinto el Borde
	DC.EnmarcarRegion(&Region, &Brocha, 4, 4);
	Brocha.AsignarColor(RGB(128,128,128));
	DC.EnmarcarRegion(&Region, &Brocha, 2, 2);

	if (ActualizacionDesdeElPlayer == true) {
		TituloStr = TEXT("Actualizacin de BubaTronik");
		TextoStr = TEXT("Se esta aplicando la ultima actualizacin de BubaTronik.\n\nEste proceso no deberia durar mas de unos minutos.\n\nEn cuanto termine la actualizacin se volvera a iniciar BubaTronik.");
	}
	else {
		TituloStr = TEXT("Instalador de BubaTronik");
		TextoStr = TEXT("Bienvenido a la instalacion de BubaTronik, este programa te permitira instalar el reproductor en tu\nsistema.\n\nPara proseguir con la instalacion verifica el directorio donde se va a instalar el reproductor, por\ndefecto el reproductor se instalara en tu carpeta '\\Archivos de programa\\BubaTronik\\', si eliges \notra carpeta se creara la sub-carpeta '\\BubaTronik\\' automaticamente.\n\nPulsa el boton Instalar para continuar la instalacin, o el boton Salir para cancelar la instalacin.");
	}
	// Pinto el logo y el titulo
	DC.PintarIcono(4, 4, 16, 16, IDI_LOGO);
	DC.Fuente(Fuente());
	DC.ModoBk(TRANSPARENT);
	DC.ColorTexto(RGB(0,0,0));
	DC.PintarTexto(TituloStr(), 26, 6);
	DC.ColorTexto(RGB(255,255,255));
	DC.PintarTexto(TituloStr(), 25, 5);

	// Pinto el texto de la descripcion
	Recta.Asignar(11, 26, ANCHO_INSTALADOR - 20, 130);
	DC.Fuente(Fuente2());
	DC.ColorTexto(RGB(0,0,0));
	DC.PintarTexto(TextoStr(), &Recta);
	Recta.operator --();
	DC.ColorTexto(RGB(255,255,255));
	DC.PintarTexto(TextoStr(), &Recta);

	// Pinto el DC en la ventana
	DC.PintarMapaBits(hDC, 0, 0, ANCHO_INSTALADOR, ALTO_INSTALADOR, 0, 0);
	return 0;
}


// El evento no llega
LRESULT VentanaPrincipal::Evento_Mouse_Movimiento(const int cX, const int cY, UINT Param) {
	if (Param == MK_LBUTTON) SendMessage(_hWnd, WM_NCLBUTTONDOWN, HTCAPTION, 0); //  Muevo la ventana siguiendo la posicion del raton
	return 0;
}


LRESULT	VentanaPrincipal::Evento_Cerrar(void) {
	PostQuitMessage(0);
	return 0;
}

void VentanaPrincipal::EliminarDirectorio(const TCHAR *Path) {
    WIN32_FIND_DATA		FindInfoPoint;
	HANDLE				hFind						= NULL;
	ZeroMemory(FindInfoPoint.cFileName, sizeof(TCHAR) * 260);
	DWL::DWLString PathBuscar;
	PathBuscar = Path; PathBuscar += TEXT("\\*.*");
	hFind = FindFirstFile(PathBuscar(), &FindInfoPoint);
	if (hFind == INVALID_HANDLE_VALUE) return;
	do {
		if (FindInfoPoint.cFileName[0] != TEXT('.')) { 
			PathBuscar = Path;
			PathBuscar += TEXT("\\");
			PathBuscar += FindInfoPoint.cFileName;
			if (FindInfoPoint.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) { // dir
				EliminarDirectorio(PathBuscar());
			}
			else {
//				MessageBox(NULL, PathBuscar(), TEXT("Borrando :"), MB_OK);
				DeleteFile(PathBuscar());
			}
		}
	} while (FindNextFile(hFind, &FindInfoPoint) != 0);
	FindClose(hFind);
	RemoveDirectory(Path);
}


void VentanaPrincipal::Instalar(void) {
	// Eliminar archivos y directorios viejos
	DWL::DWLString PathVLC1;
	DWL::DWLString PathPlugins;
	PathVLC1 = Edit.Texto();
	PathPlugins = PathVLC1;
	if (PathVLC1[PathVLC1.Tam() - 1] == TEXT('\\'))			PathVLC1 += TEXT("LibVLC 1.0");
	else													PathVLC1 += TEXT("\\LibVLC 1.0");
	if (PathPlugins[PathPlugins.Tam() - 1] == TEXT('\\'))	PathPlugins += TEXT("Plugins");
	else													PathPlugins += TEXT("\\Plugins");
//	MessageBox(NULL, PathVLC1(), TEXT("Borrando :"), MB_OK);
	EliminarDirectorio(PathVLC1());
	EliminarDirectorio(PathPlugins());

	// Extraemos los datos
	Ex.ExtraerDatos(Edit.Texto());
	Barra_Progreso.Maximo(Ex.TotalArchivos());
	while(Ex.ExtraerArchivo() == true) { 
		Barra_Progreso.Valor_SumarValor(1);
		BarraTareas.BarraProgreso_Valor(Barra_Progreso.Valor(), Ex.TotalArchivos());
	}
	BarraTareas.BarraProgreso_Ocultar();

//	MessageBox(_hWnd, TEXT("Instalacion terminada con exito!!"), TEXT("Instalacion terminada"), MB_OK);
	DWL::DWLString Str;
	// Crear acceso directo en el escritorio (El acceso directo no se crea)
	if (Marca_CrearAccesoDirecto.Marcado() == true) {
		Str = Edit.Texto();
		if (Str[Str.Tam() -1] != TEXT('\\')) Str += TEXT('\\');
		Str += TEXT("BubaTronik.exe");

		DWL::DWLString PathFinalEscritorio;
		Sistema.Directorio.Escritorio(PathFinalEscritorio);
		if (PathFinalEscritorio[PathFinalEscritorio.Tam() -1] != TEXT('\\')) PathFinalEscritorio += TEXT('\\');
		PathFinalEscritorio += TEXT("BubaTronik.lnk");
		bool z = DWL::Archivos::DWLArchivosWindows::CrearAccesoDirecto(Str(), Edit.Texto(), NULL, TEXT("Ejecutar reproductor BubaTronik"), Str(), 0, PathFinalEscritorio());
//		MessageBox(NULL, Str(), PathFinalEscritorio(), MB_OK);
//		DWL::DWLDebug::ImprimirDebug(TEXT("%s, %s\n"), Str(), PathFinalEscritorio());
	}
	// Mostrar notas (Funciona bien)
	if (Marca_MostrarNotas.Marcado() == true) {
		Str = Edit.Texto();
		if (Str[Str.Tam() -1] != TEXT('\\')) Str += TEXT('\\');
		Str += TEXT("Leeme.txt");
		ShellExecute( NULL, TEXT("open"), Str(), TEXT(""), Edit.Texto(), SW_SHOWNORMAL);
//		MessageBox(NULL, Str(), Str(), MB_OK);
//		DWL::DWLDebug::ImprimirDebug(TEXT("%s %s\n", Str(), TEXT("Proba")));
	}
	// Ejecutar BubaTronik
	if (Marca_EjecutarBubaTronik.Marcado() == true) Ex.EjecutarArchivo();
	Evento_Cerrar();																// Termino la aplicacion
}


// El evento no llega.....
LRESULT VentanaPrincipal::Evento_BotonEx_Mouse_Click(const UINT Boton, const int cX, const int cY, const UINT IDBotonEx, UINT Param) {
	switch (IDBotonEx) {
		case ID_BOTON_SALIR :
			Evento_Cerrar();
			break;
		case ID_BOTON_INSTALAR :
			Instalar();
			break;
	}
	return 0;
}